# TeamViewer Full Uninstall Script for Intune
$logPath = "C:\ProgramData\AnF\TeamViewer\Logs"
$timestamp = Get-Date -Format "yyyy-MM-dd_HH-mm-ss"
$scriptLog = Join-Path $logPath "TV_Full_Uninstall_${timestamp}.log"

New-Item -Path $logPath -ItemType Directory -Force | Out-Null
"=== TeamViewer Uninstall Started [$timestamp] ===" | Out-File $scriptLog -Encoding UTF8

# Stop TeamViewer process and service if running
Stop-Process -Name "TeamViewer" -Force -ErrorAction SilentlyContinue
Stop-Service -Name "TeamViewer" -Force -ErrorAction SilentlyContinue

# Wait for service to stop (max 60s)
for ($i = 0; $i -lt 60; $i++) {
    $svc = Get-Service -Name "TeamViewer" -ErrorAction SilentlyContinue
    if (!$svc -or $svc.Status -eq "Stopped") { break }
    Start-Sleep -Seconds 1
}
if ($i -ge 60) { "WARNING: Service did not stop after 60s." | Out-File $scriptLog -Append }

# Uninstall TeamViewer via MSI product code if found
$uninstallKeys = @(
    "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall",
    "HKLM:\SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall"
)
$found = $false
foreach ($key in $uninstallKeys) {
    Get-ChildItem $key -ErrorAction SilentlyContinue | ForEach-Object {
        $props = Get-ItemProperty $_.PSPath -ErrorAction SilentlyContinue
        if ($props.DisplayName -like "*TeamViewer*" -and $props.UninstallString -match "\{[0-9A-Fa-f\-]{36}\}") {
            $found = $true
            Start-Process "msiexec.exe" -ArgumentList "/X $($matches[0]) /qn /norestart" -Wait -NoNewWindow
        }
    }
}

if ($found) {
    "Uninstall status: Success" | Out-File $scriptLog -Append
    exit 0
} else {
    "Uninstall status: No TeamViewer found" | Out-File $scriptLog -Append
    exit 1
}
